﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.MFIC;

namespace MicroRWD.UI.MFIC
{
    public partial class WriteToCardMemoryForm : Form
    {
        public WriteToMemoryPanel Panel { get { return writeToMemoryPanel; } }

        public WriteToCardMemoryForm()
        {
            InitializeComponent();
        }

        public WriteToCardMemoryForm(int _count, ListView _listView, int _selectedIndex, int _descriptionSubItem, MFICReader _reader)
        {
            InitializeComponent();

            Panel.Count = _count;
            Panel.DescriptionSubItem = _descriptionSubItem;
            Panel.ListView = _listView;

            // Read initial card data
            ReadCardData();
            Panel.ListView.Items[_selectedIndex].Selected = true;
        }

        private void ReadCardData()
        {
            byte[] reply = Program.Controller.Reader.CmdLabelBlockRead(Panel.Address);
            if (reply.Length > 0)
            {
                if (reply.Length == Panel.Count + 1)
                {
                    byte[] data = new byte[Panel.Count];
                    for (int i = 0; i < Panel.Count; ++i)
                    {
                        data[i] = reply[i + 1];
                    }
                    Panel.Data = data;
                    Panel.ListView.Items[Panel.Address].SubItems[1].Text = String.Join(string.Empty, Array.ConvertAll(data, b => b.ToString("X2") + ' '));
                }
                else
                {
                    Panel.Data = null;
                    Panel.ListView.Items[Panel.Address].SubItems[1].Text = "<NO DATA>";
                }
            }
            else
            {
                Panel.Data = null;
                Panel.ListView.Items[Panel.Address].SubItems[1].Text = "";
            }
        }

        private bool WriteCardData()
        {
            bool result = false;

            // If data is valid
            if (Panel.Data != null)
            {
                // Write to card
                byte[] reply = Program.Controller.Reader.CmdLabelBlockWrite(Panel.Address, Panel.Data);
                if (reply.Length > 0)
                {
                    if (reply.Length == 1)
                    {
                        byte ack = reply[0];

                        if ((ack & 0xFE) == 0x86)
                        {
                            Panel.ListView.Items[Panel.Address].SubItems[1].Text = String.Join(string.Empty, Array.ConvertAll(Panel.Data, b => b.ToString("X2") + ' '));
                            Panel.ListView.Items[Panel.Address].SubItems[2].Text = String.Join(string.Empty, Array.ConvertAll(Panel.Data, b => ((b > 31) && (b < 127)) ? ((char)b).ToString() + ' ' : ". "));
                            result = true;
                        }
                    }
                }
            }

            return result;
        }

        private void writeToMemoryPanel_Click_CloseButton(object sender, EventArgs e)
        {
            Close();
        }

        private void writeToMemoryPanel_Click_WriteButton(object sender, EventArgs e)
        {
            if (!WriteCardData())
            {
                // Write failed - read current value back
                ReadCardData();
            }
            
            // Refresh panel
            Panel.Modified = false;
            Panel.UpdateView();
        }

        private void writeToMemoryPanel_Address_Changed(object sender, EventArgs e)
        {
            // Address changed - trigger read
            ReadCardData();

            // Refresh panel
            Panel.Modified = false;
            Panel.UpdateView();
        }
    }
}
